/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin;

import io.neox.neonium.VeryEarlyModDetector;
import java.io.File;
import java.util.List;
import java.util.Set;
import me.jellysquid.mods.sodium.common.config.MixinConfig;
import me.jellysquid.mods.sodium.common.config.SodiumConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class SodiumMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "me.jellysquid.mods.sodium.mixin.";
    private static final String[] PROBLEM_MIXINS = new String[]{"me.jellysquid.mods.sodium.mixin.features.chunk_rendering.MixinRenderGlobal", "me.jellysquid.mods.sodium.mixin.features.particle.cull.MixinParticleManager", "me.jellysquid.mods.sodium.mixin.features.chunk_rendering.MixinWorldRenderer", "me.jellysquid.mods.sodium.mixin.features.chunk_rendering.MixinChunkBuilder"};
    private final Logger logger = LogManager.getLogger((String)"Neonium");
    private SodiumConfig config;
    private boolean littleTilesLogged = false;
    private boolean littleTilesDetected = false;
    private boolean sgcraftLogged = false;
    private boolean sgcraftDetected = false;

    public SodiumMixinPlugin() {
        this.tryDetectIncompatibleMods();
    }

    private void tryDetectIncompatibleMods() {
        try {
            this.littleTilesDetected = VeryEarlyModDetector.isLittleTilesPresent();
            if (!this.littleTilesDetected) {
                try {
                    Class.forName("com.creativemd.littletiles.LittlePatchingLoader", false, this.getClass().getClassLoader());
                    this.littleTilesDetected = true;
                    System.out.println("[Neonium] LittleTiles detected via direct class check in MixinPlugin!");
                }
                catch (ClassNotFoundException e) {
                    try {
                        Class.forName("com.creativemd.littletiles.LittleTilesTransformer", false, this.getClass().getClassLoader());
                        this.littleTilesDetected = true;
                        System.out.println("[Neonium] LittleTiles detected via LittleTilesTransformer class check!");
                    }
                    catch (ClassNotFoundException ex) {
                        this.littleTilesDetected = false;
                    }
                }
            }
            this.sgcraftDetected = VeryEarlyModDetector.isSGCraftPresent();
            if (!this.sgcraftDetected) {
                try {
                    Class.forName("gcewing.sg.SGCraft", false, this.getClass().getClassLoader());
                    this.sgcraftDetected = true;
                    System.out.println("[Neonium] SGCraft detected via direct class check in MixinPlugin!");
                }
                catch (ClassNotFoundException e) {
                    try {
                        Class.forName("gcewing.sg.SGCraftClient", false, this.getClass().getClassLoader());
                        this.sgcraftDetected = true;
                        System.out.println("[Neonium] SGCraft detected via SGCraftClient class check!");
                    }
                    catch (ClassNotFoundException ex) {
                        this.sgcraftDetected = false;
                    }
                }
            }
            if (this.littleTilesDetected) {
                System.out.println("[Neonium] LittleTiles detected at MixinPlugin constructor time!");
            }
            if (this.sgcraftDetected) {
                System.out.println("[Neonium] SGCraft detected at MixinPlugin constructor time!");
            }
        }
        catch (Throwable t) {
            System.err.println("[Neonium] Error during early mod detection: " + t.getMessage());
        }
    }

    public void onLoad(String mixinPackage) {
        this.tryDetectIncompatibleMods();
        try {
            this.config = SodiumConfig.load(new File(".").toPath().resolve("config").resolve("neonium-mixins.properties").toFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load configuration file for Neonium", e);
        }
        this.logger.info("Loaded configuration file for Neonium: {} options available, {} override(s) found", (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
        if (this.littleTilesDetected) {
            this.logger.info("[LittleTilesCompat] LittleTiles detected on mixin load, incompatible mixins will be disabled");
        }
        if (this.sgcraftDetected) {
            this.logger.info("[SGCraftCompat] SGCraft detected on mixin load, incompatible mixins will be disabled");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(MIXIN_PACKAGE_ROOT)) {
            this.logger.error("Expected mixin '{}' to start with package root '{}', treating as foreign and disabling!", (Object)mixinClassName, (Object)MIXIN_PACKAGE_ROOT);
            return false;
        }
        if (this.littleTilesDetected || this.sgcraftDetected) {
            for (String problemMixin : PROBLEM_MIXINS) {
                if (!mixinClassName.equals(problemMixin)) continue;
                if (this.littleTilesDetected && !this.littleTilesLogged) {
                    this.logger.info("[LittleTilesCompat] LittleTiles detected, disabling incompatible mixins for compatibility");
                    this.littleTilesLogged = true;
                }
                if (this.sgcraftDetected && !this.sgcraftLogged) {
                    this.logger.info("[SGCraftCompat] SGCraft detected, disabling incompatible mixins for compatibility");
                    this.sgcraftLogged = true;
                }
                if (this.littleTilesDetected) {
                    this.logger.info("Disabling mixin '{}' for LittleTiles compatibility", (Object)mixinClassName);
                }
                if (this.sgcraftDetected && !this.littleTilesDetected) {
                    this.logger.info("Disabling mixin '{}' for SGCraft compatibility", (Object)mixinClassName);
                }
                return false;
            }
        }
        if (!this.littleTilesDetected && !this.sgcraftDetected && MixinConfig.shouldDisableMixin(mixinClassName)) {
            this.logger.info("Disabling mixin '{}' for compatibility via MixinConfig", (Object)mixinClassName);
            return false;
        }
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        SodiumConfig.Option option = this.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            this.logger.error("No rules matched mixin '{}', treating as foreign and disabling!", (Object)mixin);
            return false;
        }
        if (option.isUserDefined()) {
            String source = "user configuration";
            if (option.isEnabled()) {
                this.logger.warn("Force-enabling mixin '{}' as rule '{}' (added by {}) enables it", (Object)mixin, (Object)option.getKey(), (Object)source);
            } else {
                this.logger.warn("Force-disabling mixin '{}' as rule '{}' (added by {}) disables it and children", (Object)mixin, (Object)option.getKey(), (Object)source);
            }
        }
        return option.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

